<?php



// --- State Management ---

function getState(): ?array {

	global $STATE_FILE;

	if (!file_exists($STATE_FILE)) return null;

	$data = json_decode(file_get_contents($STATE_FILE), true);

	return $data ?: null;

}



function setState(string $chatId, string $action, $data = null): void {

	global $STATE_FILE;

	$state = [

		'chat_id' => $chatId,

		'action' => $action,

		'data' => $data

	];

	file_put_contents($STATE_FILE, json_encode($state, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

}



function clearState(): void {

	global $STATE_FILE;

	if (file_exists($STATE_FILE)) {

		unlink($STATE_FILE);

	}

}



// --- Bot Status ---

function getBotStatus(): bool {

	global $BOT_STATUS_FILE;

	if (!file_exists($BOT_STATUS_FILE)) return true;

	$status = trim(file_get_contents($BOT_STATUS_FILE));

	return $status === 'on' || $status === '1';

}



function setBotStatus(bool $status): void {

	global $BOT_STATUS_FILE;

	file_put_contents($BOT_STATUS_FILE, $status ? 'on' : 'off');

}



?>