<?php



/**

 * Advertisement Integration for Main Bot

 * 

 * این فایل برای ادغام سیستم تبلیغات همگانی با ربات اصلی طراحی شده است

 */



use RubikaBot\Bot;



/**

 * ارسال تبلیغات همگانی از طریق ربات اصلی

 */

function send_mass_advertisement_from_bot(Bot $bot, ?PDO $pdo, string $chatId, string $message): void {

    // اجرای سیستم تبلیغات همگانی

    $scriptPath = __DIR__ . "/../scripts/mass_advertisement.php";

    $command = "php " . escapeshellarg($scriptPath) . " " . escapeshellarg($message) . " > /dev/null 2>&1 &";

    

    if (PHP_OS_FAMILY === 'Windows') {

        $command = "start /B php " . escapeshellarg($scriptPath) . " " . escapeshellarg($message);

    }

    

    exec($command);

    

    $bot->chat($chatId)->message("🚀 تبلیغات همگانی آغاز شد!\n\n📊 سیستم در حال ارسال پیام به تمام کاربران ربات‌های ساخته شده است\n\n⏱️ گزارش‌های پیشرفت به زودی ارسال خواهد شد\n\n💡 می‌توانید وضعیت را از طریق لاگ‌ها پیگیری کنید")->send();

}



/**

 * ارسال فوروارد همگانی از طریق ربات اصلی

 */

function send_mass_forward_from_bot(Bot $bot, ?PDO $pdo, string $chatId, string $fromChatId, string $messageId): void {

    // اجرای سیستم فوروارد همگانی

    $scriptPath = __DIR__ . "/../scripts/mass_advertisement.php";

    $command = "php " . escapeshellarg($scriptPath) . " --forward " . escapeshellarg($fromChatId) . " " . escapeshellarg($messageId) . " > /dev/null 2>&1 &";

    

    if (PHP_OS_FAMILY === 'Windows') {

        $command = "start /B php " . escapeshellarg($scriptPath) . " --forward " . escapeshellarg($fromChatId) . " " . escapeshellarg($messageId);

    }

    

    exec($command);

    

    $bot->chat($chatId)->message("📤 فوروارد همگانی آغاز شد!\n\n🔄 سیستم در حال فوروارد پیام به تمام کاربران ربات‌های ساخته شده است\n\n⏱️ گزارش‌های پیشرفت به زودی ارسال خواهد شد\n\n💡 می‌توانید وضعیت را از طریق لاگ‌ها پیگیری کنید")->send();

}



/**

 * نمایش آمار تبلیغات همگانی

 */

function show_mass_advertisement_stats(Bot $bot, PDO $pdo, string $chatId): void {

    $logFile = __DIR__ . '/advertisement_log.txt';

    

    if (!file_exists($logFile)) {

        $bot->chat($chatId)->message("📊 هنوز هیچ تبلیغاتی ارسال نشده است")->send();

        return;

    }

    

    // خواندن آخرین خطوط لاگ

    $logs = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    $recentLogs = array_slice($logs, -10); // آخرین 10 خط

    

    $message = "📊 آمار تبلیغات همگانی\n\n";

    $message .= "📁 آخرین فعالیت‌ها:\n";

    

    foreach ($recentLogs as $log) {

        if (strpos($log, 'Mass advertisement completed') !== false) {

            // استخراج آمار از لاگ

            $statsJson = substr($log, strpos($log, '{'));

            $stats = json_decode($statsJson, true);

            

            if ($stats) {

                $message .= "\n✅ آخرین تبلیغات:\n";

                $message .= "🤖 ربات‌ها: {$stats['total_bots']}\n";

                $message .= "👥 کاربران: {$stats['total_users']}\n";

                $message .= "✅ موفق: {$stats['successful_sends']}\n";

                $message .= "❌ ناموفق: {$stats['failed_sends']}\n";

                break;

            }

        }

    }

    

    $message .= "\n💡 برای مشاهده جزئیات بیشتر به فایل لاگ مراجعه کنید";

    

    $bot->chat($chatId)->message($message)->send();

}



/**

 * پاک کردن لاگ‌های تبلیغات

 */

function clear_advertisement_logs(Bot $bot, PDO $pdo, string $chatId): void {

    $logFile = __DIR__ . '/advertisement_log.txt';

    

    if (file_exists($logFile)) {

        unlink($logFile);

        $bot->chat($chatId)->message("🗑️ لاگ‌های تبلیغات پاک شد")->send();

    } else {

        $bot->chat($chatId)->message("📁 هیچ فایل لاگی برای پاک کردن وجود ندارد")->send();

    }

}



/**

 * دریافت تعداد کل کاربران همه ربات‌ها

 */

function get_total_users_count(PDO $pdo): int {

    $stmt = $pdo->prepare("SELECT bot_username FROM bots");

    $stmt->execute();

    $bots = $stmt->fetchAll(PDO::FETCH_COLUMN);

    

    $totalUsers = 0;

    

    foreach ($bots as $botUsername) {

        $botDbFile = CREATED_BOTS_DIR . '/' . $botUsername . '/' . $botUsername . '_series.sqlite';

        

        if (file_exists($botDbFile)) {

            try {

                $botPdo = new PDO('sqlite:' . $botDbFile);

                $botPdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                

                $stmt = $botPdo->prepare("SELECT COUNT(*) FROM users");

                $stmt->execute();

                $count = $stmt->fetchColumn();

                

                $totalUsers += $count;

                

            } catch (PDOException $e) {

                error_log("Error counting users for bot {$botUsername}: " . $e->getMessage());

            }

        }

    }

    

    return $totalUsers;

}



/**

 * دریافت آمار کامل ربات‌ها

 */

function get_bots_statistics(PDO $pdo): array {

    $stmt = $pdo->prepare("SELECT bot_username, created_at FROM bots ORDER BY created_at DESC");

    $stmt->execute();

    $bots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    

    $stats = [

        'total_bots' => count($bots),

        'total_users' => 0,

        'bots_with_users' => 0,

        'bots_detail' => []

    ];

    

    foreach ($bots as $bot) {

        $botDbFile = CREATED_BOTS_DIR . '/' . $bot['bot_username'] . '/' . $bot['bot_username'] . '_series.sqlite';

        

        $botUsers = 0;

        if (file_exists($botDbFile)) {

            try {

                $botPdo = new PDO('sqlite:' . $botDbFile);

                $botPdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                

                $stmt = $botPdo->prepare("SELECT COUNT(*) FROM users");

                $stmt->execute();

                $botUsers = $stmt->fetchColumn();

                

            } catch (PDOException $e) {

                error_log("Error getting stats for bot {$bot['bot_username']}: " . $e->getMessage());

            }

        }

        

        $stats['total_users'] += $botUsers;

        if ($botUsers > 0) {

            $stats['bots_with_users']++;

        }

        

        $stats['bots_detail'][] = [

            'username' => $bot['bot_username'],

            'users' => $botUsers,

            'created_at' => $bot['created_at']

        ];

    }

    

    return $stats;

}



?>

