<?php

require_once 'Database.php';



echo "🔄 اجرای migration دیتابیس...\n";



try {

    // Create database instance - this will run migrations automatically

    $db = new \RubikaBot\Database();

    $pdo = $db->getPdo();

    

    // Check if bot_type column exists

    $stmt = $pdo->query("PRAGMA table_info(bots)");

    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    

    $botTypeExists = false;

    foreach ($columns as $column) {

        if ($column['name'] === 'bot_type') {

            $botTypeExists = true;

            break;

        }

    }

    

    if ($botTypeExists) {

        echo "✅ ستون bot_type وجود دارد.\n";

        

        // Show current data

        $stmt = $pdo->query("SELECT COUNT(*) as total FROM bots");

        $total = $stmt->fetchColumn();

        echo "📊 تعداد کل ربات‌ها: {$total}\n";

        

        if ($total > 0) {

            $stmt = $pdo->query("SELECT bot_username, bot_type FROM bots LIMIT 5");

            $bots = $stmt->fetchAll();

            echo "🤖 نمونه ربات‌ها:\n";

            foreach ($bots as $bot) {

                echo "   - @{$bot['bot_username']} : {$bot['bot_type']}\n";

            }

        }

    } else {

        echo "❌ ستون bot_type وجود ندارد!\n";

        echo "🔧 تلاش برای اضافه کردن...\n";

        

        $pdo->exec('ALTER TABLE bots ADD COLUMN bot_type TEXT DEFAULT "series"');

        echo "✅ ستون bot_type اضافه شد.\n";

    }

    

    echo "\n🎉 Migration با موفقیت انجام شد!\n";

    

} catch (Exception $e) {

    echo "❌ خطا در migration: " . $e->getMessage() . "\n";

}

?>

